//
//  GHHeartRateData.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 8/1/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  Battery status values.
 */
typedef NS_ENUM(uint32_t, GHHeartRateStatus) {
    /**
     *  The heart rate value may be valid as
     *  a clean signal is has been established.
     */
    GHHeartRateStatusLocked = 0,

    /**
     *  The heart rate value may be invalid as
     *  a clean signal is has not been established.
     */
    GHHeartRateStatusSearching = 1,

    /**
     *  The heart rate value is invalid as it
     *  appears that the device is not being worn.
     */
    GHHeartRateStatusOffWrist = 2
};


#pragma mark -
/**
 *  The GHHeartRateData class provides information about heart rate.
 */
@interface GHHeartRateData : NSObject <NSCoding>

/** Timestamp of the heart beat record */
@property (nonatomic, readonly) NSDate *timestamp;

/** Indicates the status of the data */
@property (nonatomic, readonly) GHHeartRateStatus status;

/** Average heart rate reported in the interval. */
@property (nonatomic, readonly) NSNumber *beatsPerMinute;


@end
